/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.png;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class MetadataTag {
    private final File f;
    private final String tag;

    public MetadataTag(File f, String tag) {
        this.f = f;
        this.tag = tag;
    }

    public String getData() throws IOException {
        ImageInputStream iis = ImageIO.createImageInputStream(this.f);
        Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
        if (readers.hasNext()) {
            ImageReader reader = readers.next();
            reader.setInput(iis, true);
            IIOMetadata metadata = reader.getImageMetadata(0);
            String[] names = metadata.getMetadataFormatNames();
            int length = names.length;
            for (int i = 0; i < length; ++i) {
                String result = this.displayMetadata(metadata.getAsTree(names[i]));
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private String displayMetadata(Node root) {
        return this.displayMetadata(root, 0);
    }

    private String displayMetadata(Node node, int level) {
        Node text;
        Node keyword;
        NamedNodeMap map = node.getAttributes();
        if (map != null && (keyword = map.getNamedItem("keyword")) != null && this.tag.equals(keyword.getNodeValue()) && (text = map.getNamedItem("value")) != null) {
            return text.getNodeValue();
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String result = this.displayMetadata(child, level + 1);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

